#ifndef EXTAPP_CRYS_DEFINES
#define EXTAPP_CRYS_DEFINES

/*
*  Object ExtApp_CRYS_Defines.h
*  State           :  %state%
*  Creation date   :  Thu Dec 09 10:43:04 2004
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief Common defines used in HOST-SEP protocol by CRYS external SEP application tests
*
*  \version ExtApp_CRYS_Defines.h#1:incl:1
*  \author 
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/


/* sizes in words */
#define AES_MaxIVCounterSize                    4   
#define AES_MaxKeySize                          8   

	/* message length except buffers */
#define	DX_SEP_HOST_SEP_AESNOTINTEGRATED_MSG_LENGTH_IN_WORDS	DX_SEP_HOST_AES_DATAIN_OFFSET /* msg len in words = 19 */

/* AES offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_AES_KEYTYPE_OFFSET          = 0,
    DX_SEP_HOST_AES_ENCDEC_OFFSET           = 1,
    DX_SEP_HOST_AES_MODE_OFFSET             = 2,
    DX_SEP_HOST_AES_ISSECRETKEY_OFFSET      = 3,
    DX_SEP_HOST_AES_OUTPUTLOCATION_OFFSET   = 4,
    DX_SEP_HOST_AES_DATAINSIZE_OFFSET       = 5,
    DX_SEP_HOST_AES_DATAEXPSIZE_OFFSET      = 6,
    DX_SEP_HOST_AES_IVCOUNTER_OFFSET        = 7,
    DX_SEP_HOST_AES_KEYPTR_OFFSET           = DX_SEP_HOST_AES_IVCOUNTER_OFFSET + AES_MaxIVCounterSize, // 11
    DX_SEP_HOST_AES_DATAIN_OFFSET           = DX_SEP_HOST_AES_KEYPTR_OFFSET + AES_MaxKeySize,

	DX_SEP_HOST_AES_Last                    = 0x7FFFFFFF 
    
}DX_SEP_HOST_AES_Parameters_Offsets;

/**********************************DES**************************************/
/***************************************************************************/

#define DES_MaxIVCounterSize                    CRYS_DES_IV_SIZE_IN_WORDS   
#define DES_MaxKeySize                          8   

/* message length except buffers */
#define	DX_SEP_HOST_SEP_DESNOTINTEGRATED_MSG_LENGTH_IN_WORDS	DX_EXT_SEP_HOST_DES_NOINTEG_DATA_IN_OFFSET 

/* DES offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_DES_KEYTYPE_OFFSET          = 0,
    DX_SEP_HOST_DES_ENCDEC_OFFSET           = 1,
    DX_SEP_HOST_DES_MODE_OFFSET             = 2,
    DX_SEP_HOST_DES_OUTPUTLOCATION_OFFSET   = 3,
    DX_SEP_HOST_DES_DATAINSIZE_OFFSET       = 4,
    DX_SEP_HOST_DES_DATAEXPSIZE_OFFSET      = 5,
    DX_SEP_HOST_DES_IVCOUNTER_OFFSET        = 6,
    DX_SEP_HOST_DES_KEYPTR_OFFSET           = DX_SEP_HOST_DES_IVCOUNTER_OFFSET + DES_MaxIVCounterSize,
    DX_SEP_HOST_DES_DATAIN_OFFSET           = DX_SEP_HOST_DES_KEYPTR_OFFSET + DES_MaxKeySize,

	DX_SEP_HOST_DES_Last                    = 0x7FFFFFFF 
    
}DX_SEP_HOST_DES_Parameters_Offsets;

/**********************************HASH**************************************/
/***************************************************************************/

/* message length except buffers */
#define	DX_SEP_HOST_SEP_HASH_MSG_LENGTH_IN_WORDS	DX_EXT_SEP_HOST_HASH_DATA_IN_OFFSET /* msg len in words =  */

/* HASH offsets of the parameters in the message (in words) */
typedef enum
{
	DX_SEP_HOST_HASH_MODE_OFFSET            = 0,
	DX_SEP_HOST_HASH_DATAINSIZE_OFFSET      = 1,
	DX_SEP_HOST_HASH_DATAEXPSIZE_OFFSET     = 2,
	DX_SEP_HOST_HASH_DATAIN_OFFSET          = 3,

	DX_SEP_HOST_HASH_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_HASH_Parameters_Offsets;

/**********************************HMAC**************************************/
/***************************************************************************/

/* message length except buffers */
#define	DX_SEP_HOST_SEP_HMAC_MSG_LENGTH_IN_WORDS	DX_SEP_HOST_HMAC_KEYPTR_OFFSET /* msg len in words =  */

/* HMAC offsets of the parameters in the message (in words) */
typedef enum
{
	DX_SEP_HOST_HMAC_KEYSIZE_OFFSET          = 0,
	DX_SEP_HOST_HMAC_MODE_OFFSET             = 1,
	DX_SEP_HOST_HMAC_DATAINSIZE_OFFSET       = 2,
	DX_SEP_HOST_HMAC_DATAEXPSIZE_OFFSET      = 3,
	DX_SEP_HOST_HMAC_KEYPTR_OFFSET           = 4,

	DX_SEP_HOST_HMAC_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_HMAC_Parameters_Offsets;

/**********************************RC4**************************************/
/***************************************************************************/

/* message length except buffers */
#define	DX_SEP_HOST_SEP_RC4_MSG_LENGTH_IN_WORDS	DX_EXT_SEP_HOST_RC4_KEYPTR_OFFSET /* msg len in words =  */

/* DES offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_RC4_KEYSIZE_OFFSET          = 0,
	DX_SEP_HOST_RC4_ENCDEC_OFFSET           = 1,
	DX_SEP_HOST_RC4_OUTPUTLOCATION_OFFSET   = 2,
	DX_SEP_HOST_RC4_DATAINSIZE_OFFSET       = 3,
	DX_SEP_HOST_RC4_DATAEXPSIZE_OFFSET      = 4,
	DX_SEP_HOST_RC4_KEYPTR_OFFSET           = 5,
	

	DX_SEP_HOST_RC4_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_RC4_Parameters_Offsets;

/**********************************RSA**************************************/
/***************************************************************************/
#define RSA_BufferMaxLength  CRYS_RSA_MAX_VALID_KEY_SIZE_VALUE_IN_BITS/8 /* in bytes */

/* message length except buffers */
#define	DX_SEP_HOST_SEP_RSA_MSG_LENGTH_IN_WORDS	 DX_SEP_HOST_RSA_PubExponent_OFFSET/* msg len in words =  */

/* RSA offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_RSA_DATASIZE_IN_OFFSET          = 0,
	DX_SEP_HOST_RSA_PUBEXPONENTSIZE_OFFSET      = 1,
	DX_SEP_HOST_RSA_PRIVEXPONENTSIZE_OFFSET     = 2,
	DX_SEP_HOST_RSA_KEYSIZE_OFFSET              = 3,
	DX_SEP_HOST_RSA_KEYGENTYPE_OFFSET           = 4,
	DX_SEP_HOST_RSA_CRTMODE_OFFSET              = 5,
	DX_SEP_HOST_RSA_PSIZE_OFFSET                = 6,
	DX_SEP_HOST_RSA_QSIZE_OFFSET                = 7,
	DX_SEP_HOST_RSA_dPSIZE_OFFSET               = 8,
	DX_SEP_HOST_RSA_dQSIZE_OFFSET               = 9,
	DX_SEP_HOST_RSA_qInvSIZE_OFFSET             = 10,
	DX_SEP_HOST_RSA_HASHMODE_OFFSET             = 11,
	DX_SEP_HOST_RSA_SALTLENGTH_OFFSET           = 12,
	DX_SEP_HOST_RSA_PubExponent_OFFSET          = 13,

	DX_SEP_HOST_RSA_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_RSA_Parameters_Offsets;

/**********************************ECC**************************************/
/***************************************************************************/

/* message length except buffers */
#define	DX_SEP_HOST_SEP_ECC_MSG_LENGTH_IN_WORDS	 DX_SEP_HOST_ECC_DataIn_OFFSET/* msg len in words =  */

/* RSA offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_ECC_DATASIZE_IN_OFFSET     = 0,
	DX_SEP_HOST_ECC_SIGNATURESIZE_OFFSET   = 1, 
	DX_SEP_HOST_ECC_KEYGENTYPE_OFFSET	   = 2,	
	DX_SEP_HOST_ECC_DOMAINID_OFFSET        = 3,
	DX_SEP_HOST_ECC_PUBLICKEYSIZE_OFFSET   = 4,
	DX_SEP_HOST_ECC_PRIVKEYSIZE_OFFSET     = 5,
	DX_SEP_HOST_ECC_HASH_OFFSET            = 6,
	DX_SEP_HOST_ECC_DataIn_OFFSET          = 7,

	DX_SEP_HOST_ECC_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_ECC_Parameters_Offsets;

#define	DX_SEP_HOST_SEP_ECC_DH_MSG_LENGTH_IN_WORDS	 DX_SEP_HOST_ECC_DH_PublKey1_OFFSET/* msg len in words =  */

typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_ECC_DH_KEYGENTYPE_OFFSET = 0,
	DX_SEP_HOST_ECC_DH_DOMAINID_OFFSET	= 1,
	DX_SEP_HOST_ECC_DH_PUBLICKEYSIZE1_OFFSET = 2,
	DX_SEP_HOST_ECC_DH_PRIVKEYSIZE1_OFFSET = 3,
	DX_SEP_HOST_ECC_DH_PUBLICKEYSIZE2_OFFSET = 4,
	DX_SEP_HOST_ECC_DH_PRIVKEYSIZE2_OFFSET = 5,
	DX_SEP_HOST_ECC_DH_MaxSecretKeySize_OFFSET = 6,
	DX_SEP_HOST_ECC_DH_PublKey1_OFFSET     = 7,

	DX_SEP_HOST_ECC_DH_Last                    = 0x7FFFFFFF 

}DX_SEP_HOST_ECC_DH_Parameters_Offsets; 

/******************************************DH******************************/
/**************************************************************************/

/* length in bytes */
#define DH_BufferMaxLength CRYS_DH_MAX_VALID_KEY_SIZE_VALUE_IN_BITS/8

/* message length except buffers */
#define	DX_SEP_HOST_SEP_DH_MSG_LENGTH_IN_WORDS	 DX_SEP_HOST_DH_GENERATOR_OFFSET/* msg len in words =  */

/* DH offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_DH_GENERATORSIZE_IN_OFFSET		 = 0,
	DX_SEP_HOST_DH_PRIMESIZE_IN_OFFSET			 = 1, 
	DX_SEP_HOST_DH_QSIZE_IN_OFFSET				 = 2,
	DX_SEP_HOST_DH_L_IN_OFFSET	                 = 3,
	DX_SEP_HOST_DH_SecretDataGenType_IN_OFFSET   = 4,
	DX_SEP_HOST_DH_KeyGetSecretKeyType_IN_OFFSET = 5,
	DX_SEP_HOST_DH_KeyLenInBits_IN_OFFSET        = 6,
	DX_SEP_HOST_DH_GENERATOR_OFFSET              = 7,
	DX_SEP_HOST_DH_Last                          = 0x7FFFFFFF 

}DX_SEP_HOST_DH_Parameters_Offsets;

/******************************************RND******************************/
/**************************************************************************/

/* message length except buffers */
#define	DX_SEP_HOST_SEP_RND_MSG_LENGTH_IN_WORDS	 1/* msg len in words =  */

/* DH offsets of the parameters in the message (in words) */
typedef enum
{
	/* SDK Op Codes */
	DX_SEP_HOST_RND_SIZE_IN_OFFSET		 = 0,
	
	DX_SEP_HOST_RND_Last                  = 0x7FFFFFFF 

}DX_SEP_HOST_RND_Parameters_Offsets;

	





					  

#ifdef __cplusplus
}
#endif

#endif  /* EXTAPP_CRYS_DEFINES */
